import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * A class that represents numeric keypads.
 * (This one illustrates layout using absolute sizes and positions.)
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class NumericPad1
       extends JPanel
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new numeric keypad.
    *
    */
   public NumericPad1()
   {  super();
      digitB = new JButton[10];
      for (int i = 0; i < 10; i++)
      {  digitB[i] = new JButton("" + i);
      }
      enterB = new JButton("Enter");

      setLayout(null);

      digitB[0].setBounds(20, 20, 240, 80);
      add(digitB[0]);

      for (int i = 1; i < 10; i++)
      {  digitB[i].setBounds(20 + 80 * ((i - 1) % 3),
            100 + 80 * ((i - 1) / 3),
            80, 80);
         add(digitB[i]);
      }

      enterB.setBounds(20 + 240, 20,
         80, 320);
      add(enterB);
   }


/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   /**
    * Array of digit buttons.
    */
   private JButton[] digitB;

   /**
    * The Enter button.
    */
   private JButton enterB;

/* =======================================================================
       TEST DRIVER
   =======================================================================
*/
   public static void main(String[] args)
   {  NumericPad1 pad = new NumericPad1();
      JFrame frm = new JFrame("Absolute Sizes and Positions");
      frm.addWindowListener(new WindowAdapter()
      {  public void windowClosing(WindowEvent we)
         {  System.exit(0);
         }
      });
      Container contentPane = frm.getContentPane();
      contentPane.add(pad);
      frm.setBounds(100, 100, 400, 400);
      frm.setVisible(true);
   }
}
