import java.awt.event.*;

/**
 * A class that represents objects that respond to button clicks
 * by incrementing and displaying a count.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class SimpleButtonListener
   implements ActionListener
{

/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new listener object.
    */
   public SimpleButtonListener()
   {
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

   /**
    * Increments a count and displays it on the standard output.
    * Invoked in response to button clicks.
    *
    * @param ae the button click event.
    */
   public void actionPerformed(ActionEvent ae)
   {  count++;
      System.out.println(count);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/  
   /**
    * The variable that keeps track of the number of times the
    * button has been clicked.
    */
   private int count;
}