import java.util.Vector;

/**
 * A class that represents stacks, implemented using Vector.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class VectorBasedStack
   implements Stack
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new empty stack.
    */
   public VectorBasedStack()
   {  v = new Vector();
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the number of objects in this stack.
    *
    * @return the number of objects in this stack.
    */
   public int size()
   {  return v.size();
   }

   /**
    * Tests whether this stack contains no objects.
    *
    * @return true if the stack is empty; false otherwise.
    */
   public boolean isEmpty()
   {  return v.isEmpty();
   }

   /**
    * Returns the top item of the stack. (It leaves the item
    * on the stack and returns a reference to it.)
    *
    * @param the top of the stack.
    */
   public Object top()
   {  if (isEmpty())
      {  // deal with error
      }
      return v.lastElement();
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Pushes an object onto the top of this stack.
    *
    * @param obj the object to push onto the stack.
    */
   public void push(Object obj)
   {  v.addElement(obj);
   }

   /**
    * Removes the object at the top of this stack and returns 
    * that object.
    *
    * @param the top of the stack.
    */
   public Object pop()
   {  if (isEmpty())
      {  // deal with error
      }
      Object elem = v.lastElement();
      v.removeElementAt(size() - 1);
      return elem;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   /**
    * The vector used to implement the stack.
    */
   private Vector v;
}