/**
 * A program that illustrates polymorphism & dynamic method binding
 * for a class hierarchy of camera shop stock.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class TakingStock
{
   public static void main(String[] args)
   {  /* Assume the inventory is kept in an array
         (a polymorphic data structure)
       */
      InventoryItem[] inventory = 
                        new InventoryItem[5];

      /* The array would be filled from a file,
         but we'll do it explicitly.
       */
      inventory[0] = new Lens("Canon 28-80 mm f/3.5-5.6 EF Lens",
         111123, 12, 185, 28, true);
      inventory[1] = new Film("FujiFilm - 35mm 24exp 200-ISO Color Print Film",
         999918, 191, 2, 20, 24);
      inventory[2] = new Lens("Nikon - 20MM F/2.8D AF Lens",
         111132, 2, 495, 20, false);
      inventory[3] = new Camera("Minolta - QTsi SLR Camera",
         333721, 4, 297, true, 2000, "black");
      inventory[4] = new Camera("Pentax - ZX-50 Quartz Date SLR Camera",
         333885, 3, 350, true, 500, "black");
/*
      inventory[5] = new FlashGun("Quantaray - QAF 6600 Series",
         666612, 8, 80, 100);
*/
      // Now exploit dynamic method binding
      for (int i = 0; i < inventory.length; i++)
      {  inventory[i].display();
      }
   }
}