/**
 * A class that represents lenses that are in the inventory
 * of a camera shop.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class Lens 
   extends InventoryItem
{  
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new inventory item.
    *
    * @param aDescription describes the inventory item.
    * @param anInventoryNumber identifies the item.
    * @param theQuantityOnHand how many there are in the store.
    * @param thePrice how much each one costs.
    * @param theFocalLength the focal length of the lens.
    * @param theIsZoom whether this lens is a zoom lens or not.
    */
   public Lens(String aDescription, int anInventoryNumber, 
      int theQuantityOnHand, int thePrice, int theFocalLength,
      boolean theIsZoom)
   {  super(aDescription, anInventoryNumber, theQuantityOnHand, thePrice);
      focalLength = theFocalLength;
      isZoom = theIsZoom;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Displays details of this lens on the screen.
    */
   public void display()
   {  System.out.println("Lens " + inventoryNumber +
         quantityOnHand + " " +  focalLength);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   /**
    * The focal length of the lens.
    */
   protected double focalLength;

   /**
    * Whether this lens is a zoom lens or not.
    */
   protected boolean isZoom;
}