/**
 * A program that demonstrated polymorphism & dynamic method binding
 * on a class hierarchy of animals.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class SingAlong
{
   private static Animal[] livestock;

   public static void main(String[] args)
   {  // Set up the array of animals
      livestock = new Animal[3];
      livestock[0] = new Cow();
      livestock[1] = new Pig();
      livestock[2] = new Aardvark();

      // Introduce each one in turn
      for (int i = 0; 
           i < livestock.length; i++)
      {  System.out.print(
            "Old MacDonald had a farm. ");
         System.out.println(
            "Eee Eye, Eee Eye, Oh!");
         System.out.print(
            "And on that farm he had some ");
         System.out.print(
            livestock[i].getBreed() + ". ");
         System.out.println(
            "Eee Eye, Eee Eye, Oh!");
         for (int j = i; j >= 0; j--)
         {  chorus(livestock[j]);
         }
         System.out.print(
            "Old MacDonald had a farm. "); 
         System.out.println(
            "Eee Eye, Eee Eye, Oh!");
         System.out.println();
       }  
   }

   private static void chorus(Animal a)
   {  System.out.print("With a \"");
      a.talk();
      a.talk();
      System.out.print("\" here, and a \"");
      a.talk(); 
      a.talk();
      System.out.println("\" there.");
      System.out.print("Here a \"");
      a.talk();
      System.out.print("\", there a \"");
      a.talk();
      System.out.println("\".");
      System.out.print("Everywhere a \"");
      a.talk(); 
      a.talk();
      System.out.println("\".");
   }
}