/**
 * A class that represents an academic's scholarly publications.
 * @author Derek Bridge
 */
public class Publication
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new publication object.
    *
    * @param the publication's title.
    * @param the name of the publication's author.
    * @param the year of publication.
    */
   public Publication(String theTitle, PersonName theAuthor, 
      int theYearOfPub)
   {  title = theTitle;
      author = theAuthor;
      yearOfPub = theYearOfPub;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/


/* --Getters----------------------------------------------------------- */

   /**
    * Returns the publication's title.
    *
    * @return the publication's title.
    */
   public String getTitle()
   {  return title;
   }

   /**
    * Returns the name of the publication's author.
    *
    * @return the name of the publication's author.
    */
   public PersonName getAuthor()
   {  return author;
   }

   /**
    * Returns the year of publication.
    *
    * @return the year of publication.
    */
   public int getYearOfPub()
   {  return yearOfPub;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   /**
    * The title of the publication.
    */
   private String title;

   /**
    * The name of the publication's author.
    */
   private PersonName author;

   /**
    * The year of publication.
    */
   private int yearOfPub;
}
