/**
 * A class that represents library books.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class LibraryBook
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new library book object 
    * with the given author and title,
    * and assumes that the library has
    * one copy of this book.
    *
    * @param theAuthor the book's author.
    * @param theTitle the book's title.
    */
   public LibraryBook(PersonName theAuthor,
      String theTitle)
   {  author = theAuthor;
      title = theTitle;
      numOfCopies = 1;
   }

   /**
    * Allocates a new library book object 
    * with the given author, title and
    * specified number of copies.
    *
    * @param theAuthor the book's author.
    * @param theTitle the book's title.
    * @param theNumOfCopies the number of
    * copies possessed by the library.
    */
   public LibraryBook(PersonName theAuthor,
      String theTitle, int theNumOfCopies)
   {  author = theAuthor;
      title = theTitle;
      numOfCopies = theNumOfCopies;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the number of copies of 
    * this book possessed by the library.
    *
    * @return the number of copies 
    * possessed.
    */
   public int getNumOfCopiesPossessed()
   {  return numOfCopies;
   }

   /**
    * Returns the number of copies of
    * this book that are on loan.
    *
    * @return the number of copies on
    * loan.
    */
   public int getNumOfCopiesOnLoan()
   {  return numOfCopiesOnLoan;
   }

   /**
    * Returns the number of copies of
    * this book that are not on loan.
    *
    * @return the number of copies not
    * on loan.
    */
   public int getNumOfCopiesOnShelves()
   {  return numOfCopies - numOfCopiesOnLoan;
   }

   /**
    * Displays details of this book and
    * the loan status of its copies.
    *
    */
   public void display()
   {  System.out.println(author.getLastFirst() +
         ": " + title);
      System.out.println("   Copies possessed: " +
         numOfCopies + "   Copies on shelves: " +
         getNumOfCopiesOnShelves() + "   Copies on loan: " +
         numOfCopiesOnLoan);
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Record the fact that a copy of this
    * book has been borrowed.
    * Should only be invoked when the
    * number of copies on the shelves > 0.
    */
   public void takeOut()
   {  numOfCopiesOnLoan++;
   }

   /**
    * Record the fact that a copy of this
    * book has been returned.
    * Should only be invoked when the
    * number of copies on loan > 0.
    */
   public void bringBack()
   {  numOfCopiesOnLoan--;
   }

   /**
    * Record the fact that a copy of this
    * book has been acquired.
    */
   public void acquire()
   {  numOfCopies++;
   }

   /**
    * Record the fact that the specified
    * number of copies of this book
    * have been acquired.
    *
    * @param theNumOfNewCopies the number
    * of newly acquired copies of this
    * book.
    */
   public void acquire(int theNumOfNewCopies)
   {  numOfCopies += theNumOfNewCopies;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The book's author.
    */
   private PersonName author; 

   /**
    * The book's title.
    */
   private String title; 

   /**
    * The total number of copies possessed by the library.
    */
   private int numOfCopies; 

   /**
    * The number of copies on loan.
    */
   private int numOfCopiesOnLoan; 

}