<?php 
    require_once( 'output_functions.php' );
    require_once( 'validation_functions.php' );
    
    function output_form_page( &$errors )
    {
        output_header('Rodents Reunited: Login', 'rr.css');    
        echo "<form action=\"{$_SERVER['PHP_SELF']}\" method=\"post\">";
        output_textfield('username', 'User name: ', 'username', 30, 30, 
                isset($_POST['username']) ? $_POST['username'] : '', false);
        output_passwordfield('password', 'Password: ', 'password', 10, 10, '', false);
        output_submit_button('Login'); 
        output_reset_button('Reset');
        if ( count($errors) > 0 )
        {
            output_unordered_list( array_values($errors) );
        }
        echo "</form>";
        output_footer('Rodents Reunited Inc.');    
    }
    
    function output_problem_page()
    {
        output_header('Rodents Reunited: Problem', 'rr.css'); 
        output_paragraph( 'We are undergoing scheduled maintenance.' );
        output_footer('Rodents Reunited Inc.'); 
    }
    
    function is_initial_request()
    {
        return ! isset($_POST['submit']);
    }
    
    $errors = array();
    if ( is_initial_request() )
    {
        output_form_page( $errors );
    }
    else
    {
        // Connect to database
        $dbconnection = mysqli_connect( $host, $user, $password, $dbname );
        if ( ! $dbconnection )
        {
            output_problem_page();
            die();
        }
   
        // Get user's data
        $username = get_required_string( 
            $_POST, 'username', 'Username', 30, $errors ); 
        $password = get_required_string(
            $_POST, 'password', 'Password', 10, $errors );
        if ( count( $errors ) > 0 )
        {
            output_form_page( $errors );
        }
        else
        {
            // One-way encrypt the password
            $md5_password = md5( $password );          

            // Check whether this user name and password match one on the database
            $sql = "SELECT * FROM users 
                    WHERE username = '{$username}'
                    AND  password = '{$md5_password}';";
            $dbresult = mysqli_query( $dbconnection, $sql );
            if ( ! $dbresult )
            {
                output_problem_page();
                mysqli_close( $dbconnection );
                die();
            }
            if ( mysqli_num_rows( $dbresult ) != 1 )
            {
                $errors['username'] = 'Incorrect login';
                output_form_page( $errors );
            }
            else
            {
                // All is well with this user
                // Store his/her name in the session store and show links to the protected content!
                session_start();
                $_SESSION['authenticated'] = true;
                $_SESSION['username'] = $username;
                output_header( 'Rodents Reunited: Members only content', 'rr.css' );
                output_paragraph( 'Welcome back to Rodents Reunited' );
                $menu = array('<a href="wombats.php">Wombat Lovers\' Corner</a>', 
                          '<a href="squirrels.php">Squirrel Lovers\' Corner</a>');
                output_unordered_list( $menu );
                output_footer( 'Rodents Reunited Inc.' );
            }
            mysqli_free_result( $dbresult );
        }
        mysqli_close( $dbconnection );
    }
?>
