<?php
    require_once('output_functions.php');
    
    // If this is an on-going session, obtain the $cart array.
    // If it's a new session, create an empty array
    session_start();
    if ( isset($_SESSION['cart']) )
    {
	    $cart = $_SESSION['cart'];
    }
    else
    {
	    $cart = array();
    }
 
    // Get the id of the item being added to the cart
    $id = (int) $_GET['id'];
 
    // If this item is in the cart already, then increment the quantity.
    // If not, insert it.
    if ( isset($cart[$id]) )
    {
	    $cart[$id]++;
    }
    else
    {
	    $cart[$id] = 1;
    }
 
    // Put the revised cart back into the session store
    $_SESSION['cart'] = $cart;
    
    output_header( 'Item successfully added to your cart', 'sbw.css' );
?>

    <p>
        <a href="show_cart.php">Show cart</a>
    </p>
    <p>
        <a href="show_catalog.php">Show catalog</a>
    </p>

<?php
    output_footer( 'Shrine of Bacchus Wines' );
?>