import java.util.*;

/**
 * A class that represents collections of Orders.
 * @author Derek Bridge
 */
public class OrderCollection
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new, empty collection of Orders.
    */
   public OrderCollection()
   {  orders = new Vector();
   }

   /** 
    * Allocates a new collection of orders based on an existing
    * Vector of orders.
    *
    * @param theOrders the Vector of orders that initialises this
    * collection.
    */
   public OrderCollection(Vector theOrders)
   {  orders = theOrders;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns all orders in the collection.
    */
   public Vector findAll()
   {  return orders;
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Add the specified Order object to the collection.
    *
    * @param theOrder the Order being added to the collection; must be 
    * non-null & not already in the collection.
    */
   public void add(Order theOrder)
   {  orders.addElement(theOrder);
   }

   /**
    * Remove the specified Order from the collection.
    *
    * @param theOrder the Order to be removed; must be non-null and
    * an Order already in the collection.
    */
   public void remove(Order theOrder)
   {  orders.removeElement(theOrder);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   private Vector orders;
}
