import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * A class that represents GUIs for the CD tele-sales company.
 * @author Derek Bridge
 */
public class MainGUI
   extends JFrame
   implements ICDGUI
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new main GUI object for a specified collection of
    * customers, orders and CDs.
    *
    * @param theCustCollection the collection of customers.
    * @param theOrderCollection the collection of orders.
    * @param theCDCollection the collection of CDs.
    */
   public MainGUI(CustomerCollection theCustCollection, 
      OrderCollection theOrderCollection, CDCollection theCDCollection)
   {  super("CD-Direkt");
      custCollection = theCustCollection;
      orderCollection = theOrderCollection;
      cdCollection = theCDCollection;
      custBtn = new JButton("Customers");
      custBtn.addActionListener(new ActionListener()
      {  public void actionPerformed(ActionEvent ae)
         {  disableGUI();
            CustomerGUI custGUI = new CustomerGUI(
               MainGUI.this, custCollection, cdCollection);
            custGUI.setVisible(true);
         }
      });
      orderBtn = new JButton("Orders");
      orderBtn.addActionListener(new ActionListener()
      {  public void actionPerformed(ActionEvent ae)
         {  disableGUI();
            OrderGUI orderGUI = new OrderGUI(
               MainGUI.this, orderCollection, cdCollection);
            orderGUI.setVisible(true);
         }
      });
      cdBtn = new JButton("CDs");
      cdBtn.addActionListener(new ActionListener()
      {  public void actionPerformed(ActionEvent ae)
         {  disableGUI();
            CDGUI cdGUI = new CDGUI(MainGUI.this, cdCollection);
            cdGUI.setVisible(true);
         }
      });
      Container contentPane = getContentPane();
      contentPane.setLayout(new GridLayout(1, 3));
      contentPane.add(custBtn);
      contentPane.add(orderBtn);
      contentPane.add(cdBtn);
      pack();
   }


/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Setters----------------------------------------------------------- */

   /**
    * Disables this GUI when the user goes to another GUI.
    */
   public void disableGUI()
   {  custBtn.setEnabled(false);
      orderBtn.setEnabled(false);
      cdBtn.setEnabled(false);
   }

   /**
    * Enable this GUI when the user returns from another GUI.
    */
   public void enableGUI()
   {  custBtn.setEnabled(true);
      orderBtn.setEnabled(true);
      cdBtn.setEnabled(true);
   }

   /**
    * If one GUI sends you to another GUI and that GUI wants to
    * supply a result, it does so using this setter. But this
    * main GUI, it does nothing with any such result.
    *
    * @param anObj the result being supplied.
    */
   public void setResult(Object anObj)
   {
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private JButton custBtn;
   private JButton orderBtn;
   private JButton cdBtn;
   private CustomerCollection custCollection;
   private OrderCollection orderCollection;
   private CDCollection cdCollection;

/* =======================================================================
       TEST DRIVER
   =======================================================================
*/
   public static void main(String[] args)
   {  CustomerCollection custCollection = new CustomerCollection();
      Customer c1 = new Customer("Ann", "3 The Street", "ATown", "123");
      Customer c2 = new Customer("Ben", "4 The Road", "ATown", "456");
      Customer c3 = new Customer("Col", "5 The Avenue", "SomeTown", "789");
      custCollection.add(c1);
      custCollection.add(c2);
      custCollection.add(c3);

      CDCollection cdCollection = new CDCollection();
      CD cd1 = new CD("Java Jivers", "Class definition", 1099);
      cd1.addTrack("How many actual arguments?");
      cd1.addTrack("Class definition");
      cd1.addTrack("Can't call you cos you're out of scope");
      cd1.addTrack("Your love is a procedural abstraction");
      cd1.addTrack("Love on Trial (Integration Testing)");
      CD cd2 = new CD("Jumbled Java Head", 
         "Can't compile, Won't compile", 1599);
      cd2.addTrack("Volatile, transient and final");
      cd2.addTrack("Pluggable look-and-feel");
      cd2.addTrack("Asymptotic nightmares");
      cd2.addTrack("Dirty Window Listener");
      CD cd3 = new CD("Byte Code Boyz", "Incompatible types", 1299);
      cd3.addTrack("Incompatible types");
      cd3.addTrack("Letting it all go public");
      cd3.addTrack("Overloaded again");
      cd3.addTrack("Overridden once more");
      cd3.addTrack("You take precedence");
      CD cd4 = new CD("Jack Javac and the Applets", "Swing component", 699);
      cd4.addTrack("Private declaration");
      cd4.addTrack("Three part message");
      cd4.addTrack("Single inheritance");
      cd4.addTrack("Last minute comments");
      CD cd5 = new CD("Jumbled Java Head", "Null Pointer Exception", 1699);
      cd5.addTrack("Hitting the hash table");
      cd5.addTrack("Exponential growth");
      cd5.addTrack("Hide behind your interface");
      cd5.addTrack("Null Pointer Exception");
      cd5.addTrack("Package visibility");
      cdCollection.add(cd1);
      cdCollection.add(cd2);
      cdCollection.add(cd3);
      cdCollection.add(cd4);
      cdCollection.add(cd5);

      OrderCollection orderCollection = new OrderCollection();
      Order order1 = new Order(c1, "Zach", "040300", "Ben", "2 A Street",
         "A City", "MasterCard", "3333333", "Ann", "02 2004");
      order1.addOrderLine(new OrderLine(cd1, 2));
      order1.addOrderLine(new OrderLine(cd2, 1));
      Order order2 = new Order(c2, "Yvonne", "030300", "Deb", "2 A Street",
         "A City", "Visa", "444444", "Mr Ben", "03 2004");
      order2.addOrderLine(new OrderLine(cd1, 2));
      order2.addOrderLine(new OrderLine(cd2, 1));
      order2.addOrderLine(new OrderLine(cd3, 1));
      orderCollection.add(order1);
      orderCollection.add(order2);
      c1.addOrder(order1);
      c2.addOrder(order2);

      JFrame mainGUI = new MainGUI(
         custCollection, orderCollection, cdCollection);
      mainGUI.addWindowListener(new WindowAdapter()
      {  public void windowClosing(WindowEvent we)
         {  System.exit(0);
         }
      });
      mainGUI.setVisible(true);
   }
}
