/**
 * An interface that defines the type of GUI used for CD-Direkt.
 * These GUIs disable themselves when the user goes to another screen
 * of the GUI and are re-enabled when the user returns.
 * @author Derek Bridge
 */
public interface ICDGUI
{
   /**
    * Disables this GUI when the user goes to some other GUI.
    */
   public void disableGUI();

   /**
    * Enable this GUI when the user returns from some other GUI.
    */
   public void enableGUI();

   /**
    * If one GUI sends you to another GUI and that GUI wants to
    * supply a result, it does so using this setter.
    *
    * @param anObj the result being supplied.
    */
   public void setResult(Object anObj); 

   public static final String RETURN = "RETURN";
}