import java.awt.*;
import java.awt.event.*;

/**
 * A utility class containing a method for adding components to
 * containers using grid bag layout.
 * @author Derek Bridge
 */
public class GuiUtility
{
   /**
    * Utility method for adding components to a container using
    * grid bag layout constraints.
    *
    * @param comp the component being added.
    * @param cont the container we're adding to.
    * @param gbl the layout manager.
    * @param gbc the layout manager's constraints object.
    * @param row the row we're positioning in.
    * @param col the column we're positioning in.
    * @param numRows the number of rows this component is to span.
    * @param numCols the number of columns this component is to span.
    * @param weightx horizontal resize weight.
    * @param weighty horizontal resize weight.
    */
   public static void addComp(Component comp, Container cont, 
      GridBagLayout gbl, GridBagConstraints gbc, int row, int col, 
      int numRows, int numCols, double weightx, double weighty)
   {  gbc.gridx = col;
      gbc.gridy = row;
      gbc.gridwidth = numCols;
      gbc.gridheight = numRows;
      gbc.weightx = weightx;
      gbc.weighty = weighty;

      cont.add(comp, gbc);
   }
}
