import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

/**
 * A class that represents a GUI to a temperature conversion program.
 * @author Derek Bridge
 */
public class TempConversionGUI
   extends JFrame
   implements ActionListener
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new window that displays Fahrenheit and corresponding
    * centigrade temperatures and offers button for requesting conversion
    * between the two.
    */
   public TempConversionGUI()
   {  fahrLabel = new JLabel(DEGREES_FAHRENHEIT);
      fahrField = new JTextField(INIT_FAHR, TFCOLS);
      centLabel = new JLabel(DEGREES_CENTIGRADE);
      centField = new JTextField(INIT_CENT, TFCOLS);
      compFahrBtn = new JButton(COMPUTE_FAHRENHEIT);
      compCentBtn = new JButton(COMPUTE_CENTIGRADE);

      Container contentPane = getContentPane();

      FlowLayout layout = new FlowLayout();
      contentPane.setLayout(layout);

      contentPane.add(fahrLabel);
      contentPane.add(fahrField);
      contentPane.add(centLabel);
      contentPane.add(centField);
      contentPane.add(compFahrBtn);
      contentPane.add(compCentBtn);

      compFahrBtn.addActionListener(this);
      compCentBtn.addActionListener(this);

      addWindowListener(new WindowAdapter()
      {  public void windowClosing(WindowEvent we)
         {  System.exit(0);
         }
      });
   }


/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Public class constants-------------------------------------------- */

   public static final String 
      DEGREES_FAHRENHEIT = "Degrees Fahrenheit"; // textfield label
   public static final String
      DEGREES_CENTIGRADE = "Degrees Centigrade"; // textfield label
   public static final String 
      COMPUTE_FAHRENHEIT = "Compute Fahrenheit"; // button text
   public static final String
      COMPUTE_CENTIGRADE = "Compute Centigrade"; // button text

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the current value in the Fahrenheit textfield as an int.
    *
    * @param the current value in the Fahrenheit textfield, converted to
    * an int.
    */
   public int getFahrField()
   {  String str = fahrField.getText().trim();
      return Integer.parseInt(str);
   }

   /**
    * Returns the current value in the centigrade textfield as an int.
    *
    * @param the current value in the centigrade textfield, converted to
    * an int.
    */
   public int getCentField()
   {  String str = centField.getText().trim();
      return Integer.parseInt(str);
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Updates the value in the Fahrenheit textfield.
    *
    * @param theFahr the new Fahrenheit value.
    */
   public void setFahrField(int theFahr)
   {  fahrField.setText("" + theFahr);
   }

   /**
    * Updates the value in the centigrade textfield.
    *
    * @param theCent the new centigrade value.
    */
   public void setCentField(int theCent)
   {  centField.setText("" + theCent);
   }

   /**
    * Gets a temperature from this GUI, converts it and informs this GUI of 
    * the new value.
    * Invoked in response to button clicks. The event source may be one
    * of two buttons, depending on whether the user wants to convert
    * Fahrenheit to centigrade or vice versa.
    *
    * @param ae the button click event.
    */
   public void actionPerformed(ActionEvent ae)
   {  if (ae.getSource() == compFahrBtn)
      {  int cent = getCentField();
         int fahr = (int) Math.round(cent * 9.0 / 5.0 + 32);
         setFahrField(fahr);
      }
      else
      {  int fahr = getFahrField();
         int cent = (int) Math.round((fahr - 32) * 5.0 / 9.0);
         setCentField(cent);
      }
   }


/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private JLabel fahrLabel;
   private JTextField fahrField;
   private JLabel centLabel;
   private JTextField centField;
   private JButton compFahrBtn;
   private JButton compCentBtn;

   private static final String 
      INIT_FAHR = "212"; // initial Fahrenheit value (212 F = 100 C)
   private static final String 
      INIT_CENT = "100"; // initial centigrade value (100C = 212 F)
   private static final int TFCOLS = 6; // textfield width (no. of cols)

/* =======================================================================
       TEST DRIVER
   =======================================================================
*/
   public static void main(String[] args)
   {  JFrame tcg = new TempConversionGUI();
      tcg.setBounds(50, 75, 250, 150);
      tcg.setVisible(true);
   }
}