/**
 * A Java interface that specifies what it means to be a till GUI.
 * @author Derek Bridge
 */
public interface ITillGUI
{  
   /**
    * Return the last price that was rung up.
    *
    * @return the last price that was rung up.
    */
   public int getPriceEntered();

   /**
    * Bring the visual appearance of the GUI up-to-date.
    * This will be done by using getters on the model object and putting
    * these values into the visual display of the GUI.
    */
   public void update();

   public static final String ENTER = "Enter";
   public static final String SUBMIT = "Submit";
   public static final String CANCEL = "Cancel";
}
