import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * A class that allows testing of a till, its GUI and the GUIs controller
 * (listener).
 * @author Derek Bridge
 */
public class TillMain
{
   public static void main(String[] args)
   {  /* Create till and GUI (the latter creates its controller).
         Associate GUI with till using the setter.
       */
      Till till = new Till(1000); // 1000 is the float (10 pounds)
      ITillGUI gui = new TillGUI(till);
      till.setGUI(gui);

      /* Till GUIs are simply subclasses of JPanel, so we add the GUI
         to a JFrame and make the JFrame visible.
       */
      JFrame frame = new JFrame();
      Container contentPane = frame.getContentPane();
      contentPane.add((JComponent) gui);
      frame.addWindowListener(new WindowAdapter()
      {  public void windowClosing(WindowEvent we)
         {  System.exit(0);
         }
      });
      frame.pack();
      frame.setLocation(100, 100);
      frame.setVisible(true);
   }
}