import java.awt.event.*;

/**
 * A class that represents objects that respond to till events.
 * @author Derek Bridge
 */
public class TillController
       implements ActionListener
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new till controller object that can respond to till
    * events.
    *
    * @param theTill the till being controlled.
    * @param theGUI the till's GUI.
    */
   public TillController(Till theTill, ITillGUI theGUI)
   {  till = theTill;
      gui = theGUI;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

   /**
    * The handler method: responds to the three main actions of a till
    * GUI: entering a price for a customer purchase (ENTER); concluding
    * a transaction successfully (SUBMIT) or aborting a transaction
    * (CANCEL).
    *
    * @param ae the button click event.
    */
   public void actionPerformed(ActionEvent ae)
   {  String str = ae.getActionCommand();
      if (str.equals(ITillGUI.ENTER)) 
      {  till.ringUpItem(gui.getPriceEntered()); 
      }
      else if (str.equals(ITillGUI.SUBMIT))
      {  till.ringUpItem(gui.getPriceEntered());
         till.submitTransaction();
      }
      else // i.e. cancel
      {  till.cancelTransaction();
      }
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private Till till;
   private ITillGUI gui;
}