/**
 * A class that represents cash till objects.
 * Till objects keep track of floats, takings and numbers of 
 * transactions.
 * @author Derek Bridge
 */
public class Till
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new till object with the given initial float.
    *
    * @param theTillFloat the initial float in the till, prior to any
    * transactions.
    */
   public Till(int theTillFloat)
   {  tillFloat = theTillFloat;
   }


/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the float that was in the till.
    *
    * @return the amount of the float in the till.
    */
   public int getTillFloat()
   {  return tillFloat;
   }

   /**
    * Returns the amount of money taken.
    *
    * @return the amount of the takings.
    */
   public int getTakings()
   {  return takings;
   }

   /**
    * Returns the amount of money that should be in the till.
    *
    * @return the amount of money that should be in the till.
    */
   public int getTillTotal()
   {  return takings + tillFloat;
   }

   /**
    * Returns the number of transactions there have been.
    *
    * @return the number of transactions.
    */
   public int getTransactionCount()
   {  return transactionCount;
   }

   /**
    * Returns the total amount owed by this customer.
    *
    * @return the total amount owed by this customer.
    */
   public int getTotalOwed()
   {  return amountOwedByThisCust;
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Rings up an item, i.e. adds the price of the latest item that is
    * being purchased by this customer to the running total owed by
    * this customer.
    *
    * @param theItemPrice the price of the item.
    */
   public void ringUpItem(int theItemPrice)
   {  amountOwedByThisCust += theItemPrice;
      if (gui != null)
      {  gui.update();
      }
   }

   /**
    * Concludes the transaction with this customer by updating the takings
    * and the transaction count, and prepares for next customer.
    */
   public void submitTransaction()
   {  transactionCount++;
      takings += amountOwedByThisCust;
      amountOwedByThisCust = 0;
      if (gui != null)
      {  gui.update();
      }
   }

   /**
    * Cancels this customer's transaction and prepares for next customer.
    */
   public void cancelTransaction()
   {  amountOwedByThisCust = 0;
      if (gui != null)
      {  gui.update();
      }
   }

   /**
    * Sets the till's gui.
    *
    * @param theGUI the till's gui.
    */
   public void setGUI(ITillGUI theGUI)
   {  gui = theGUI;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
                         
   /* Variables that keep track of overall state of play for this till:
      the initial float, the total takings and the number of transactions.
    */
   private int tillFloat;
   private int takings;
   private int transactionCount;

   /* Variable that keeps track of the present customer's transaction.
    */
   private int amountOwedByThisCust;

   /* For tills that have GUIs, this variable references the GUI object.
    */
   private ITillGUI gui;
}
