import javax.swing.JFrame;
import java.awt.Container;
import javax.swing.JButton;
import java.awt.event.ActionListener;

/**
 * A class that represents titled windows whose content panes are
 * fully occupied by a single simple button.
 * @author Derek Bridge
 */
public class FrameWithButton
   extends JFrame
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new window containing a button.
    */
   public FrameWithButton()
   {  super("A Frame With A Button");
      Container contentPane = getContentPane();
      btn = new JButton("Press me");
      contentPane.add(btn);
      ActionListener lstnr = new SimpleButtonListener();
      btn.addActionListener(lstnr);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private JButton btn;

/* =======================================================================
       TEST DRIVER
   =======================================================================
*/
   public static void main(String[] args)
   {  JFrame fwb = new FrameWithButton();
      // fwb.setSize(400, 200);
      fwb.setBounds(100, 300, 400, 200);
      fwb.setVisible(true);
   }
}      