import java.util.*;
import javax.swing.*;

/**
 * A class that represents burger bars. Each burger bar object has
 * a till and a bill-of-fare (the shit they have on offer).
 * @author Derek Bridge
 */
public class BurgerBar
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new burger bar.
    */
   public BurgerBar()
   {  till = new Till(TILL_FLOAT);
      currentOrder = new DefaultListModel();
      /* You would now read the bill of fare in from a file.
         That way, different burger bars can easily have
         different bills of fare (by reading from different
         files). And a burger bar can easily modify its bill
         of fare over time (by changing what's in the file)
         e.g. to reflect ingredients availability or tie-ins
         with the latest Lion King  movie ("You've enjoyed
         Disney's "Lion King VII -- Now Try our Mangy Mane
         Burgers")
         For simplicity, however, we'll hard-code the bill-of-fare.
       */
      billOfFare = new Vector();
      Vector ourBurgers = new Vector();
      ourBurgers.addElement(new Burger("Aardvark Burger", 123));
      ourBurgers.addElement(new Burger("Wombat Burger", 89));
      ourBurgers.addElement(new Burger("Mulch Burger", 22));
      Vector ourSideDishes = new Vector();
      ourSideDishes.addElement(new SideDish("Greasy chips", 70));
      ourSideDishes.addElement(new SideDish("Mash", 33));
      ourSideDishes.addElement(new SideDish("Very greasy chips", 75));
      Vector ourDrinks = new Vector();
      ourDrinks.addElement(new Drink("Tap water", 176));
      ourDrinks.addElement(new Drink("Rain water", 254));
      ourDrinks.addElement(new Drink("Mulch juice", 13));
      billOfFare.addElement(ourBurgers);
      billOfFare.addElement(ourSideDishes);
      billOfFare.addElement(ourDrinks);
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* ---Getters---------------------------------------------------------- */

   /**
    * Returns this burger bar's till object.
    *
    * @return the till associated with this burger bar.
    */
   public Till getTill()
   {  return till;
   }

   /**
    * Returns this burger bar's bill-of-fare.
    *
    * @return the bill-of-fare on offer in this burger bar.
    */
   public Vector getBillOfFare()
   {  return billOfFare;
   }

   /**
    * Returns this burger bar's order for the current customer.
    *
    * @return the current customer order
    */
   public ListModel getCurrentOrder()
   {  return currentOrder;
   }

/* ---Setters---------------------------------------------------------- */


   /**
    * Adds an item to the current customer order.
    * 
    * @param theItem the item being added to the order.
    */
   public void addItemToOrder(AbstractDish theItem)
   {  currentOrder.insertElementAt(theItem, 0);
      till.ringUpItem(theItem.getPrice());
   }

   /**
    * Removes a specified item from the current customer order.
    *
    * @param theItemIndex the position in the order of the item being removed.
    */
   public void removeItemFromOrder(int theItemIndex)
   {  AbstractDish item = (AbstractDish) currentOrder.elementAt(theItemIndex);
      currentOrder.removeElementAt(theItemIndex);
      /* We must remove this from the till total too.
         Unfortunately, Till doesn't provide a method for subtracting a
         price. A hack is to ring up a negative price.
       */
      till.ringUpItem( - item.getPrice()); 
    }

   /**
    * Finalises the present customer's order, updates the till, and
    * resets variables for the next customer.
    */
   public void concludeOrder()
   {  till.submitTransaction();
      currentOrder.removeAllElements();
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private Till till;
   private Vector billOfFare;
   private DefaultListModel currentOrder;

   private static final int TILL_FLOAT = 1000;

/* =======================================================================
       Test-DRIVER
   =======================================================================
*/
   public static void main(String[] args)
   {  BurgerBar dereks = new BurgerBar();
      BurgerBarGUI gui = new BurgerBarGUI(dereks);
      gui.pack();
      gui.setVisible(true);
   }
}


