package web;

/**
 * A class that represents exceptions that are thrown when reading/writing
 * a file of URLs, and we find that what we are reading/writing is not a
 * URL.
 * @author Derek Bridge
 */
public class NotAURLFileException
   extends Exception
{
   /**
    * The exception without a message.
    */
   public NotAURLFileException()
   {  super();
   }

   /**
    * The exception with a message.
    *
    * @param msg the message.
    */
   public NotAURLFileException(final String msg)
   {  super(msg);
   }
}