package utilities;

/**
 * A class that represents exceptions that are thrown when a
 * method is invoked in a way that violates its preconditions.
 * @author Derek Bridge
 */
public class PreconditionException
   extends RuntimeException
{
   /**
    * The exception without a message.
    */
   public PreconditionException()
   {  super();
   }

   /**
    * The exception with a message.
    *
    * @param msg the message.
    */
   public PreconditionException(final String msg)
   {  super(msg);
   }
}