package utilities;

/**
 * An abstract class of objects. These objects are basically just
 * code bundles that can be passed around, stored, etc. The
 * code in the bundle can be executed in a uniform way by running
 * the object's execute() method.
 * One use is to associate these with items in a menu. When the
 * item is selected, the code bundle is executed. By dynamic method
 * binding, the right code will run, without use of `if' statements.
 * See the Command design pattern for more information.
 * @author Derek Bridge
 */
public abstract class Command
{
   public abstract void execute();
}
 