package datastructs;

import java.util.Vector;
import java.util.Enumeration;

/**
 * An implementation of the Sequence interface by subclassing Vector
 * @author Derek Bridge
 */
public class VectorSequence1 
   extends Vector
   implements Sequence
{
   /**
    * Allocates a new vector object.
    *
    */
   public VectorSequence1()
   {  // Initial size is 10, and it doubles whenever it needs to
      super();
   }

   /**
    * Returns the first object in the list.
    *
    * @return the first object in the list.
    * This must not be invoked on an empty list.
    */
   public Object getFirst()
   {  return firstElement();
   }

   /**
    * Returns the last object in the list.
    * This must not be invoked on an empty list.
    *
    * @return the last object in the list.
    */
   public Object getLast()
   {  return lastElement();
   }

   /**
    * Insert the given object into the list.
    *
    * @param anObject the object being inserted.
    */
   public void add(final Object anObject)
   {  addElement(anObject);
   }

   /**
    * Insert the given object at the front of the list.
    *
    * @param anObject the object being inserted.
    */
   public void addFirst(final Object anObject)
   {  insertElementAt(anObject, 0);
   }

   /**
    * Insert the given object at the end of the list.
    *
    * @param anObject the object being inserted.
    */
   public void addLast(final Object anObject)
   {  addElement(anObject);
   }

   /**
    * Remove the given object from the list, if it is there.
    * If the object appears more than once, its earliest occurrence is 
    * removed.
    * The list is unchanged if the object does not appear in it at all
    * (including if the list is empty).
    *
    * @param anObject the object being removed.
    */
   public void remove(final Object anObject)
   {  removeElement(anObject);
   }

   /**
    * Remove the first object from the list.
    * The list is unchanged if it is empty.
    *
    */
   public void removeFirst()
   {  removeElementAt(0);
   }

   /**
    * Remove the last object from the list.
    * The list is unchanged if it is empty.
    *
    */
   public void removeLast()
   {  removeElementAt(size() - 1);
   }
}