package datastructs;

import java.util.Enumeration;

/**
 * A program for managing a to-do list.
 * (This is rather un-object-oriented code. 
 * But it is is adequate to our purposes, i.e. it serves as an
 * example of client code for our data structure class definitions.)
 * @author Derek Bridge
 */
public class ToDoManager
{
   public static void main(String[] args)
   {  // Set up the list
      Sequence toDo = new SinglyLinkedList();
      toDo.add("Hoover the dog");
      toDo.add("Cut toe nails");
      toDo.add("Trim hair on lower back");
      toDo.add("Bury grandma");

      // Get my next task
      String myNextTask = (String) toDo.getFirst();
      myNextTask = myNextTask.toUpperCase();
      System.out.println(myNextTask);

      // Finish hoovering the dog
      finishTask(toDo, "Hoover the dog");

      // Add a new task
      toDo.add("Bury the dog");

      // Update the status of the toe nail task
      appendNote(toDo, "Cut toe nails", "(Left foot done)");

      // Print out the whole list
      System.out.println(toDo);

      // How many tasks involve burying?
      System.out.println("There are " +
         countWord(toDo, "bury") + " burying tasks.");
   }

   public static void finishTask(Sequence list, final String task)
   {  if (list.contains(task))
      {  list.remove(task);
      }
   }

   public static void appendNote(Sequence list, 
      final String task, final String note)
   {  if (list.contains(task))
      {  list.remove(task);
         list.add(task + " " + note);
      }
   }

   public static int countWord(final Sequence list, final String word)
   {  String wordInLowerCase = word.toLowerCase();
      int count = 0;
      Enumeration e = list.elements();
      while (e.hasMoreElements())
      {  String task = ((String) e.nextElement()).toLowerCase();
         if (task.indexOf(wordInLowerCase) != -1)
         {  count++;
         }
      }
      return count;
   }
}
      
   