package datastructs;

import java.util.Enumeration;

/**
 * A general abstraction over list data structures.
 * @author Derek Bridge
 */
public interface Sequence
{
   /**
    * Returns true if and only if the given object is in the list.
    *
    * @param anObject the object being sought.
    * @return true if the given object is in the list; false otherwise
    */
   public boolean contains(final Object anObject);

   /**
    * Returns the first object in the list.
    * This must not be invoked on an empty list.
    *
    * @return the first object in the list.
    */
   public Object getFirst();

   /**
    * Returns the last object in the list.
    * This must not be invoked on an empty list.
    *
    * @return the last object in the list.
    */
   public Object getLast();

   /**
    * Returns true if and only if this list is empty.
    *
    * @return true if the list is empty; false otherwise.
    */
   public boolean isEmpty();

   /**
    * Returns the size of the list.
    *
    * @return the number of nodes in the list.
    */
   public int size();

   /**
    * Returns an iterator over the list.
    *
    * @return an iterator (implementing Enumeration) over the list.
    */
   public Enumeration elements();

   /**
    * Insert the given object into the list.
    *
    * @param anObject the object being inserted.
    */
   public void add(final Object anObject);

   /**
    * Insert the given object at the front of the list.
    *
    * @param anObject the object being inserted.
    */
   public void addFirst(final Object anObject);

   /**
    * Insert the given object at the end of the list.
    *
    * @param anObject the object being inserted.
    */
   public void addLast(final Object anObject);

   /**
    * Remove the given object from the list, if it is there.
    * If the object appears more than once, its earliest occurrence is 
    * removed.
    * The list is unchanged if the object does not appear in it at all
    * (including if the list is empty).
    *
    * @param anObject the object being removed.
    */
   public void remove(final Object anObject);

   /**
    * Remove the first object from the list.
    * The list is unchanged if it is empty.
    *
    */
   public void removeFirst();

   /**
    * Remove the last object from the list.
    * The list is unchanged if it is empty.
    *
    */
   public void removeLast();

   /**
    * Returns a string representation of this list, which includes
    * string representations (computed using toString) of each
    * object in the list.
    *
    * @return a string representation of this list.
    */
   public String toString();
}