import java.util.*;

/**
 * A class that represents successor states in state space search.
 * @author Derek Bridge
 */
public class SuccessorState
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a successor state, this being a state, the name
    * of the operator used to reach this state, and the cost of
    * using the operator to generate this state.
    * @param theState the state that has been generated.
    * @param theAction the name of the operator that generated theState.
    * @param theCost the cost of applying the operator that
    * generated theState.
    */
   public SuccessorState(IState theState, String theAction,
      int theCost)
   {  state = theState;
      action = theAction;
      cost = theCost;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns this successor's state.
    */
   public IState getState()
   {  return state;
   } 

   /**
    * Returns the action that generated this successor.
    */
   public String getAction()
   {  return action;
   }

   /**
    * Returns the cost of the action that generated this successor.
    */
   public int getCost()
   {  return cost;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private IState state;
   private String action;
   private int cost;
}
