/**
 * A class for carrying out state space search but which discards any
 * successor that revisits its ancestors. (This outlaws cyclic paths.) 
 * @author Derek Bridge
 */
public class StateSpaceSearchWithNoCycles
   extends StateSpaceSearch
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new object that can carry out state space search
    * but which disallows cyclic paths.
    * @param theInitialState the initial state in this state space.
    */
   public StateSpaceSearchWithNoCycles(IState theInitialState)
   {  super(theInitialState);
   }

/* =======================================================================
       HELPER METHODS
   =======================================================================
*/
   /**
    * Adds a node to the agenda but not if its state appeared earlier on 
    * this path.
    * @param theAgenda the agenda we're adding to.
    * @param theNode the node we're adding.
    */
   protected void addNode(IAgenda theAgenda, Node theNode)
   {  Node ancestor = theNode;
      do
      {  ancestor = ancestor.getParent();
         if ((ancestor != null) &&
             (ancestor.getState().equals(theNode.getState())))
         {  return; // node is not added
         }
      } while (ancestor != null);
      super.addNode(theAgenda, theNode);
   }
}
