import java.util.*;

/**
 * A class that represents agenda for depth-first search of a
 * state space (stacks).
 * @author Derek Bridge
 */
public class StackAgenda
   implements IAgenda
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /** 
    * Allocates a new agenda for depth-first search.
    */
   public StackAgenda()
   {  stack = new Stack();
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns true iff this agenda is empty.
    */
   public boolean isEmpty()
   {  return stack.empty();
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Adds a node to the agenda.
    * @param theNode the node being added.
    */
   public void addNode(Node theNode)
   {  stack.push(theNode);
   }

   /**
    * Removes the first node from this agenda and returns it.
    * @return the removed node.
    * (Rather than implement any exception-handling, I'm 
    * assuming no client code we write will ever invoke this
    * method on an empty agenda.)
    */
   public Node removeFrontNode()
   {  return (Node) (stack.pop());
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private Stack stack;
}
