import java.util.*;

/**
 * A class for carrying out depth-first state space search, using
 * a recursive algorithm.
 * @author Derek Bridge
 */
public class RecursiveDepthFirstSearch
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new object that can carry out depth-first state space
    * search using a recursive algorithm.
    */
   public RecursiveDepthFirstSearch()
   {
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

   /**
    * Carry out a search; return the first solution path found;
    * return null if no path is found.
    * @param currentNode the node to be expanded. 
    * When this method is first called, the parameter should be a
    * node labelled by the initial state. 
    * There will then be subsequent recursive invocations of this
    * method using other nodes in the search tree.
    */
   public List getSolutionPath(Node currentNode)
   {  if (currentNode.getState().isGoal())
      {  return currentNode.getPathFromRoot();
      }
      Iterator iter = currentNode.expand().iterator();
      List path = null;
      while (iter.hasNext() && path == null)
      {  path = getSolutionPath((Node) iter.next());
      }
      return path;
   }
}
