import java.util.*;

/**
 * A class that represents agenda for breadth-first search of a
 * state space (queues).
 * @author Derek Bridge
 */
public class QueueAgenda
   implements IAgenda
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /** 
    * Allocates a new agenda for breadth-first search.
    */
   public QueueAgenda()
   {  queue = new LinkedList();
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns true iff this agenda is empty.
    */
   public boolean isEmpty()
   {  return queue.isEmpty();
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Adds a node to the agenda.
    * @param theNode the node being added.
    */
   public void addNode(Node theNode)
   {  queue.add(theNode); // `add' adds to the end.
   }

   /**
    * Removes the first node from this agenda and return it.
    * @return the removed node.
    * (Rather than implement any exception-handling, I'm 
    * assuming no client code we write will ever invoke this
    * method on an empty agenda.)
    */
   public Node removeFrontNode()
   {  return (Node) (queue.remove(0));
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   protected List queue;
}
