import java.util.*;

/**
 * A class for comparing search tree nodes using path cost.
 * @author Derek Bridge
 */
public class NodeCostComparator
   extends NodeComparator
{

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns true if one node is less than another, according to
    * their path costs.
    */
   public boolean isLessThan(Node aNode, Node otherNode)
   {  return aNode.getPathCost() < otherNode.getPathCost();
   }
}
