import java.util.*;

/**
 * A class for comparing search tree nodes using the path costs and
 * the heuristic values of the states that label these nodes.
 * (Strictly, this is only A* if the heuristic function underestimates
 * the cost of the cheapets path to the goal.)
 * @author Derek Bridge
 */
public class NodeAStarComparator
   extends NodeComparator
{

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns true if one node is less than another, according to
    * the path costs and the heuristic values of their states.
    */
   public boolean isLessThan(Node aNode, Node otherNode)
   {  return (aNode.getPathCost() + 
         aNode.getState().getHeuristicValue()) < 
         (otherNode.getPathCost() + 
         otherNode.getState().getHeuristicValue());
   }
}
