import java.util.*;

/**
 * An interface that specifies what it means to be a state in a
 * state space search.
 * @author Derek Bridge
 */
public interface IState
{
   /**
    * Tests whether this state is a goal state.
    * @return true if this state is a goal state; false otherwise.
    */
   public boolean isGoal();

   /**
    * Returns the heuristic value for this state, i.e. an estimate
    * of the cost of the cheapest path to a goal state.
    */
   public int getHeuristicValue();

   /**
    * Generates the successor states of this state.
    * @return an iterator for walking through the set of successor
    * states.
    * The successor states must be of class SuccessorState.
    */
   public Iterator getSuccessors();

   /*
      Note that your state class must include another method
      if you want to use the subclasses of StateSpaceSearch.
      Subclasses StateSpaceSearchWithNoUndos and 
      StateSpaceSearchWithNoCycles both need to test states for
      equality. So your state class would need a definition of equals.
      Both class definitions inherit versions of this method from 
      the Object class, but it is likely, when defining concrete states
      that you will want to override the inherited definition.
    */
}
