/**
 * An interface that specifies what it means to be an agenda in a
 * state space search.
 * @author Derek Bridge
 */
public interface IAgenda
{
   /**
    * Returns true iff this agenda is empty.
    */
   public boolean isEmpty();

   /**
    * Adds a node to the agenda.
    * @param theNode the node being added.
    */
   public void addNode(Node theNode);

   /**
    * Removes the first node from this agenda and return it.
    * @return the removed node.
    * (Rather than implement any exception-handling, I'm 
    * assuming no client code we write will ever invoke this
    * method on an empty agenda.)
    */
   public Node removeFrontNode();
}
