import java.util.*;

/**
 * A class that represents states in the water jugs puzzle.
 * This class uses an iconic representation: a pair of ints.
 * @author Derek Bridge
 */
public class WaterJugsState
   implements IState
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a state in the water jugs puzzle.
    * @param theX amount of water in the 4 gallon jug.
    * @param theY amount of water in the 3 gallon jug.
    */
   public WaterJugsState(int theX, int theY)
   {  x = theX;
      y = theY;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Tests whether this state is a goal state.
    * We'll hard-code a goal state: 2, n
    * @return true if this state is a goal state; false otherwise.
    */
   public boolean isGoal()
   {  return x == 2;
   }

   /**
    * Returns the heuristic value for this state, i.e. an estimate
    * of the cost of the cheapest path to a goal state.
    * The heuristic I use here is how far off the amount of water
    * in ther 4-gallon jug is from being the correct amount. This
    * is probably not a good heuristic since it doesn't reflect well
    * the number of steps it will take to get to the goal. Note that
    * it also does not necessarily underestimate the cost of the path.
    */
   public int getHeuristicValue()
   {  return Math.abs(x - 2);
   }

   /**
    * Generates the successor states of this state.
    * @return an iterator for walking through the set of successor
    * states.
    * The successor states must be of class SuccessorState.
    */
   public Iterator getSuccessors()
   {  List succStates = new ArrayList(3);
      if (x < 4)
      {  succStates.add(new SuccessorState(
            new WaterJugsState(4, y), "Fill4GfromTap", 1));
      }
      if (y < 3)
      {  succStates.add(new SuccessorState(
            new WaterJugsState(x, 3), "Fill3GfromTap", 1));
      }
      if (x > 0)
      {  succStates.add(new SuccessorState(
            new WaterJugsState(0, y), "Empty4GdownDrain", 1));
      }
      if (y > 0)
      {  succStates.add(new SuccessorState(
            new WaterJugsState(x, 0), "Empty3GdownDrain", 1));
      }
      if (x + y >= 4 && y > 0)
      {  succStates.add(new SuccessorState(
            new WaterJugsState(4, y - (4 - x)), "Fill4Gfrom3G", 1));
      }
      if (x + y >= 3 && x > 0)
      {  succStates.add(new SuccessorState(
            new WaterJugsState(x - (3 - y), 3), "Fill3Gfrom4G", 1));
      }
      if (x + y <= 4 && y > 0)
      {  succStates.add(new SuccessorState(
            new WaterJugsState(x + y, 0), "Empty3Ginto4G", 1));
      }
      if (x + y <= 3 && x > 0)
      {  succStates.add(new SuccessorState(
            new WaterJugsState(0, x+ y), "Empty4Ginto3G", 1));
      }
      return succStates.iterator();
   }

/* --Common public interface------------------------------------------- */

   /**
    * Returns true iff the parameter is equal to this state.
    * @param anObject the object being compared to this one.
    * @return true if the configurations are equal; false otherwise.
    */
   public boolean equals(Object anObject)
   {  if (this == anObject)
      {  return true;
      }
      else if (anObject == null ||
         getClass() != anObject.getClass())
      {  return false;
      }
      WaterJugsState other = (WaterJugsState) anObject;
      return x == other.x && y == other.y;
   }

   /**
    * Returns a hash code for this object.
    */
   public int hashCode()
   {  return x +  2 * y;
   }

   /**
    * Returns a string representation of this state.
    */
   public String toString()
   {  return "<" + x + ", " + y + ">";
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private int x;
   private int y;
}
