package world;
import java.io.*;
import java.util.*;

/**
 * A class that represents production systems for reflex agents.
 * @author Derek Bridge
 */
public class ProductionSystem
   implements Serializable
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new production systems object.
    */
   public ProductionSystem()
   {  ruleBase = new ArrayList(20);
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the first rule in the rule base whose condition is
    * true according to the valuation.
    */
   public StimulusResponseRule findFirstMatch(Map valuation)
   {  Iterator rulesIterator = ruleBase.iterator();
      while (rulesIterator.hasNext())
      {  StimulusResponseRule rule = 
            (StimulusResponseRule) rulesIterator.next();
         if (rule.isSatisfied(valuation))
         {  return rule;
         }
      }
      /* Otherwise, i.e. no matching rule, throw an exception.
         Since this isn't caught elsewhere, a message will appear
         on the standrad output. This would be inadequate in
         more professional code.
       */
      throw new RuntimeException("No matching rule in the rule base");
   }

   /**
    * Returns a string representation of this rule base.
    */
   public String toString()
   {  StringBuffer sb = new StringBuffer();
      Iterator iter = ruleBase.iterator();
      while (iter.hasNext())
      {  sb.append(iter.next().toString());
         sb.append("\n");
      }
      return sb.toString();
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Add a rule to the rule base.
    * @param aRule the rule to be added.
    */
   public void addRule(StimulusResponseRule aRule)
   {  ruleBase.add(aRule);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   private List ruleBase;
}
