package proplogic;
import java.util.*;

/**
 * A class that represents negated Boolean expressions.
 * @author Derek Bridge
 */
public class NOT
   extends UnaryBooleanExpression
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new negated Boolean expression.
    * @param  theArgumentExpression the expression being negated.
    */
   public NOT(BooleanExpression theArgumentExpression)
   {  super(theArgumentExpression);
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the vaue of the negated expression.
    */
   public boolean getValue(Map valuation)
   {  boolean argValue = argumentExpression.getValue(valuation);
      return ! argValue;
   }

   /**
    * Returns a string representation of this expression.
    */
   public String toString()
   {  return " NOT(" + argumentExpression.toString() + ")";
   }
}
