package gui;
import java.io.*;
import java.awt.*;
import world.*;

/**
 * A class that represents Gui components for PhysObjects in grid-like worlds.
 * @author Derek Bridge
 */
public abstract class PhysObjectGraphic
   implements Serializable
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new Gui component for a given physical object.
    * @param theObject the object whose Gui component we are creating.
    */
   public PhysObjectGraphic(PhysObject theObject)
   {  object = theObject;
      drawingPriority = DEFAULT_DRAWING_PRIORITY;
      colour = DEFAULT_COLOUR;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the component's drawing priority.
    */
   public int getDrawingPriority()
   {  return drawingPriority;
   }

/* --Setters----------------------------------------------------------- */

   /**
    * Sets the drawing priority.
    * @param theDrawingPriority the new drawing priority of this component.
    */
   public void setDrawingPriority(int theDrawingPriority)
   {  drawingPriority = theDrawingPriority;
   }

   /**
    * Sets the colour.
    * @param theColour the new colour of this component.
    */
   public void setColour(Color theColour)
   {  colour = theColour;
   }

   /**
    * Draws this component on the graphics context at the given position.
    */
   public abstract void draw(Graphics g, int x, int y);

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/

   protected PhysObject object;
   protected int drawingPriority;
   protected Color colour;

   protected static final int DEFAULT_DRAWING_PRIORITY = 5;
   protected static final Color DEFAULT_COLOUR = Color.black;
}
