package gui;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import world.*;

/**
 * A class that represents menus that offer options for creating objects.
 * @author Derek Bridge
 */
public class ObjectCreationMenu
   implements ActionListener
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new object creation menu for pulling-right.
    * @param theParent the parent component (dialogs will be centred
    * within its parent).
    * @param theWorld the world.
    */
   public ObjectCreationMenu(Component theParent, World theWorld)
   {  parent = theParent;
      world = theWorld;
      menu = new JMenu("Objects");
      ((JMenu) menu).setMnemonic('O');
      addItems();
   }

   /**
    * Allocates a new object creation menu for popping-up.
    * @param theParent the parent component (dialogs will be centred
    * within its parent).
    * @param theWorld the world.
    * @param theX the grid's x co-ordinate.
    * @param theY the grid's y co-ordinate.
    */
   public ObjectCreationMenu(Component theParent, World theWorld,
      int theX, int theY)
   {  parent = theParent;
      world = theWorld;
      menu = new JPopupMenu("Objects");
      x = theX;
      y = theY;
      addItems();
   }

/* =======================================================================
       GETTERS
   =======================================================================
*/
   /**
    * Gets the pull-right menu.
    * @return the JMenu that was created.
    */
   public JMenu getPullRightMenu()
   {  return (JMenu) menu;
   }

   /**
    * Gets the pop-up menu.
    * @return the JPopupMenu that was created.
    */
   public JPopupMenu getPopUpMenu()
   {  return (JPopupMenu) menu;
   }

   /**
    * Menu item selected.
    */
   public void actionPerformed(ActionEvent ae)
   {  String command = ae.getActionCommand();
      if (command.equals("Brick"))
      {  if (x == UNDEFINED)
         {  BrickDialog brickDialog = new BrickDialog(parent, world);
            brickDialog.setVisible(true);
         }
         else
         {  Brick brick = new Brick();
            Cell cell = world.getCells()[x][y];
            if (cell.canAccommodate(brick))
            {  brick.setCell(cell);
               cell.addObject(brick);
               world.addObject(brick);
               world.repaint();
            }
            else
            {  JOptionPane.showMessageDialog(parent, 
                  "The cell you specified has no room for this new object!",
                  "Cell occupied", JOptionPane.ERROR_MESSAGE);
            }
         }
      }
      else // some kind of agent is being created
      {  AgentDialog agentDialog = new AgentDialog(parent, world, command, x, y);
         agentDialog.setVisible(true);
      }
   }

/* =======================================================================
       HELPER METHODS
   =======================================================================
*/

   private void addItems()
   {  JMenuItem brickButton = new JMenuItem("Brick");
      brickButton.setActionCommand("Brick"); 
      brickButton.addActionListener(this);
      menu.add(brickButton);
      JMenuItem flittingLightButton = new JMenuItem("Flitting Light");
      flittingLightButton.setActionCommand("demos.FlittingLight"); 
      flittingLightButton.addActionListener(this);
      menu.add(flittingLightButton);
      JMenuItem lightSeekerButton = new JMenuItem("Light Seeker");
      lightSeekerButton.setActionCommand("demos.LightSeekingAgent"); 
      lightSeekerButton.addActionListener(this);
      menu.add(lightSeekerButton);
      JMenuItem wallFollowerButton = new JMenuItem("Wall Follower");
      wallFollowerButton.setActionCommand("demos.PSWallFollowingAgent"); 
      wallFollowerButton.addActionListener(this);
      menu.add(wallFollowerButton);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   private Component parent;
   private World world;
   private JComponent menu;
   private int x = UNDEFINED;
   private int y = UNDEFINED;
   private static final int UNDEFINED = -1;
}
