package ga;

/**
 * An interface that defines worlds in which evolved agents are tested.
 * @author Derek Bridge
 */
public interface IGAWorld
{
   /** 
    * Determines the fitness of the given agent for `survival' in this
    * world. This is an abstract method which will usually be overridden
    * by a definition in which the agent is tested on a number of tasks.
    * The agent's average score is set as its fitness.
    * @param theAgent the agent being tested.
    */
   public void evaluateFitness(IGAAgent theAgent);
}
