package demos;
import world.*;
import gui.*;
import proplogic.*;
import actions.*;

/**
 * A class of agents that follows moving light sources in grid-like worlds.
 * @author Derek Bridge
 */
public class LightSeekingAgent
   extends ProductionSystemAgent
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new light seeking agent.
    */
   public LightSeekingAgent()
   {  hasLightSensor[FRONT_LEFT] = true;
      hasLightSensor[FRONT_RIGHT] = true;
      physObjectGraphic = new PacmanGraphic(this);
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Setters----------------------------------------------------------- */

   /**
    * Creates this agent's production system.
    */
   public ProductionSystem createRules()
   {  ProductionSystem rules = new ProductionSystem();
      StimulusResponseRule r0 = 
         new StimulusResponseRule(
            new Proposition("p0"), new Turn(Turn.LEFT));
      StimulusResponseRule r1 = 
         new StimulusResponseRule(
            new Proposition("p1"), new Turn(Turn.RIGHT));
      StimulusResponseRule r2 = 
         new StimulusResponseRule(
            new AND(new NOT(new Proposition("p0")),
                    new NOT(new Proposition("p1"))),
            new Move());
      rules.addRule(r0);
      rules.addRule(r1);
      rules.addRule(r2);
      return rules;
   }

   /**
    * Convert the sensor readings into propositions.
    */
   public void preprocess()
   {  Boolean p0Value = FALSE;
      Boolean p1Value = FALSE;
      if (lightReading[FRONT_LEFT] > lightReading[FRONT_RIGHT])
      {  p0Value = TRUE;
      }
      else if (lightReading[FRONT_RIGHT] > lightReading[FRONT_LEFT])
      {  p1Value = TRUE;
      }
      propositions.put("p0", p0Value);
      propositions.put("p1", p1Value);
   }
}

