/**
 * A class that represents order line objects on customer orders.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class OrderLine
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new order line object.
    *
    * @param theCD a reference to the CD being ordered; must be non-null.
    * @param theQty the quantity being ordered; must be gerater than zero.
    */
   public OrderLine(CD theCD, int theQty)
   {  cd = theCD;
      qty = theQty;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the CD this order line is ordering.
    *
    * @return the CD.
    */
   public CD getCD()
   {  return cd;
   }

   /**
    * Returns the quantity this order line is ordering.
    *
    * @return the quantity.
    */
   public int getQty()
   {  return qty;
   }

   /**
    * Returns the price of this order line.
    *
    * @return the price of this order line (quantity times CD price).
    */
   public int getPrice()
   {  return cd.getPrice() * qty;
   }
   
/* --Setters----------------------------------------------------------- */

   /**
    * Sets the CD being ordered to the specified value.
    *
    * @param theCD the revised CD; must be non-null.
    */
   public void setCD(CD theCD)
   {  cd = theCD;
   }

   /**
    * Sets the quantity being ordered to the specified value.
    *
    * @param theQty the qunatity being ordered; must be greater than zero.
    */
   public void setQty(int theQty)
   {  qty = theQty;
   }

/* --Common object interface------------------------------------------- */

   /**
    * Returns a string representation of parts of this order line.
    *
    * @return a string representation of this order line.
    */
   public String toString()
   {  return qty + " x " + cd.toString() + 
         " = " + getPrice();
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The CD on this order line.
    */
   private CD cd;

   /**
    * The quantity of the CD on this order line.
    */
   private int qty;
}
