import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * A class that represents GUIs for the CD tele-sales company.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class MainGUI
   extends JFrame
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/

   /**
    * Allocates a new main GUI object for a specified collection of
    * customers, orders and CDs.
    *
    * @param theCustCollection the collection of customers.
    * @param theOrderCollection the collection of orders.
    * @param theCDCollection the collection of CDs.
    */
   public MainGUI(CustomerCollection theCustCollection, 
      OrderCollection theOrderCollection, CDCollection theCDCollection)
   {  super("CD-Direkt");
      custCollection = theCustCollection;
      orderCollection = theOrderCollection;
      cdCollection = theCDCollection;
      custBtn = new JButton("Customers");
      custBtn.addActionListener(new ActionListener()
      {  public void actionPerformed(ActionEvent ae)
         {  CustomerGUI custGUI = new CustomerGUI(
               MainGUI.this, custCollection, cdCollection);
            custGUI.setVisible(true);
         }
      });
      orderBtn = new JButton("Orders");
      orderBtn.addActionListener(new ActionListener()
      {  public void actionPerformed(ActionEvent ae)
         {  OrderGUI orderGUI = new OrderGUI(
               MainGUI.this, orderCollection, cdCollection);
            orderGUI.setVisible(true);
         }
      });
      cdBtn = new JButton("CDs");
      cdBtn.addActionListener(new ActionListener()
      {  public void actionPerformed(ActionEvent ae)
         {  CDGUI cdGUI = new CDGUI(MainGUI.this, cdCollection);
            cdGUI.setVisible(true);
         }
      });
      Container contentPane = getContentPane();
      contentPane.setLayout(new GridLayout(1, 3));
      contentPane.add(custBtn);
      contentPane.add(orderBtn);
      contentPane.add(cdBtn);
      pack();
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The button for launching a CustomerGUI.
    */
   private JButton custBtn;

   /**
    * The button for launching an OrderGUI.
    */
   private JButton orderBtn;

   /**
    * The button for launching a CDGUI.
    */
   private JButton cdBtn;

   /**
    * The collection of customers being used.
    */
   private CustomerCollection custCollection;

   /**
    * The collection of orders being used.
    */
   private OrderCollection orderCollection;

   /**
    * The collection of CDs being used.
    */
   private CDCollection cdCollection;

/* =======================================================================
       TEST DRIVER
   =======================================================================
*/
   public static void main(String[] args)
   {  CustomerCollection custCollection = new CustomerCollection();
      Customer c1 = new Customer("Ann", "3 The Street", "ATown", "123");
      Customer c2 = new Customer("Ben", "4 The Road", "ATown", "456");
      Customer c3 = new Customer("Col", "5 The Avenue", "SomeTown", "789");
      custCollection.add(c1);
      custCollection.add(c2);
      custCollection.add(c3);

      CDCollection cdCollection = new CDCollection();
      CD cd1 = new CD("Java Jivers", "Class definition", 1199);
      cd1.addTrack("How many actual arguments?");
      cd1.addTrack("Class definition");
      cd1.addTrack("Can't call you cos you're out of scope");
      cd1.addTrack("Your love is a procedural abstraction");
      cd1.addTrack("Love on Trial (Integration Testing)");
      CD cd2 = new CD("Jumbled Java Head", 
         "Can't compile, Won't compile", 1699);
      cd2.addTrack("Volatile, transient and final");
      cd2.addTrack("Pluggable look-and-feel");
      cd2.addTrack("Asymptotic nightmares");
      cd2.addTrack("Dirty Window Listener");
      CD cd3 = new CD("Byte Code Boyz", "Incompatible types", 1399);
      cd3.addTrack("Incompatible types");
      cd3.addTrack("Letting it all go public");
      cd3.addTrack("Overloaded again");
      cd3.addTrack("Overridden once more");
      cd3.addTrack("You take precedence");
      CD cd4 = new CD("Jack Javac and the Applets", "Swing component", 799);
      cd4.addTrack("Private declaration");
      cd4.addTrack("Three part message");
      cd4.addTrack("Single inheritance");
      cd4.addTrack("Last minute comments");
      CD cd5 = new CD("Jumbled Java Head", "Null Pointer Exception", 1799);
      cd5.addTrack("Hitting the hash table");
      cd5.addTrack("Exponential growth");
      cd5.addTrack("Hide behind your interface");
      cd5.addTrack("Null Pointer Exception");
      cd5.addTrack("Package visibility");
      cdCollection.add(cd1);
      cdCollection.add(cd2);
      cdCollection.add(cd3);
      cdCollection.add(cd4);
      cdCollection.add(cd5);

      OrderCollection orderCollection = new OrderCollection();
      Order order1 = new Order(c1, "Zach", "040301", "Ben", "2 A Street",
         "A City", "MasterCard", "3333333", "Ann", "02 2005");
      order1.addOrderLine(new OrderLine(cd1, 2));
      order1.addOrderLine(new OrderLine(cd2, 1));
      Order order2 = new Order(c2, "Yvonne", "030301", "Deb", "2 A Street",
         "A City", "Visa", "444444", "Mr Ben", "03 2005");
      order2.addOrderLine(new OrderLine(cd1, 2));
      order2.addOrderLine(new OrderLine(cd2, 1));
      order2.addOrderLine(new OrderLine(cd3, 1));
      orderCollection.add(order1);
      orderCollection.add(order2);
      c1.addOrder(order1);
      c2.addOrder(order2);

      JFrame mainGUI = new MainGUI(
         custCollection, orderCollection, cdCollection);
      mainGUI.addWindowListener(new WindowAdapter()
      {  public void windowClosing(WindowEvent we)
         {  System.exit(0);
         }
      });
      mainGUI.setVisible(true);
   }
}
