import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * A class that represents GUI objects for viewing countries.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class ViewGUI
   extends JDialog
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new GUI for viewing countries.
    *
    * @param theParentComponent the frame from which this dialog
    * was lauched (the owner of this dialog).
    * @param theCFile the file countries get retrieved from.
    */
   public ViewGUI(Frame theParentComponent, final CountryFile theCFile)
   {  super(theParentComponent, "View countries", true);
      final CountryPanel countryPanel = new CountryPanel(CountryPanel.VIEW);
      final JTextField findTF = new JTextField("", CountryPanel.TF_COLS);
      findTF.addActionListener(new ActionListener()
      {  public void actionPerformed(ActionEvent ae)
         {  try
            {  countryPanel.clear();
               String cname = findTF.getText().trim();
               Country c = theCFile.retrieve(cname);
               countryPanel.setCountry(c);
            }
            catch (NoSuchCountryException nsce)
            {  JOptionPane.showMessageDialog(null, 
                  "The file contains no country of that name",
                  "No country found", JOptionPane.INFORMATION_MESSAGE);
            }
            catch (CountryFileIOException nsce)
            {  JOptionPane.showMessageDialog(null, 
                  "There was a problem accessing the file",
                  "File problem", JOptionPane.ERROR_MESSAGE);
            }
         }
      });
      Container contentPane = getContentPane();
      contentPane.add(countryPanel, BorderLayout.NORTH);
      contentPane.add(findTF, BorderLayout.SOUTH);
      pack();
   }
}
