import java.awt.*;
import java.awt.event.*;
import java.io.*;
import javax.swing.*;

/**
 * A class that represents GUIs for managing the insertion & viewing
 * of countries.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class MainGUI
   extends JFrame
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new GUI that offers insertion and viewing options.
    */
   public MainGUI()
   {  super("Country Manager");
      JFileChooser chooser = new JFileChooser();
      int decision = chooser.showOpenDialog(this);
      File file = chooser.getSelectedFile();
      if (decision == JFileChooser.APPROVE_OPTION &&
          file != null)
      {  CountryFile cfile = new CountryFile(file);
         JButton addBtn = new JButton("ENTER COUNTRIES");
         final EnterGUI enterGui = new EnterGUI(this, cfile);
         addBtn.addActionListener(new ActionListener()
         {  public void actionPerformed(ActionEvent ae)
            {  enterGui.setVisible(true);
            }
         });
         JButton viewBtn = new JButton("VIEW COUNTRIES");
         final ViewGUI viewGui = new ViewGUI(this, cfile);
         viewBtn.addActionListener(new ActionListener()
         {  public void actionPerformed(ActionEvent ae)
            {  viewGui.setVisible(true);
            }
         });
         Container contentPane = getContentPane();
         contentPane.setLayout(new FlowLayout(10));
         contentPane.add(addBtn);
         contentPane.add(viewBtn);
         pack();
      }
      else // no file chosen
      {  System.exit(0);
      }
   }

/* =======================================================================
       TEST DRIVER
   =======================================================================
*/
   public static void main(String[] args)
   {  MainGUI gui = new MainGUI();
      gui.addWindowListener(new WindowAdapter()
      {  public void windowClosing(WindowEvent we)
         {  System.exit(0);
         }
      });
      gui.setVisible(true);
   }
}
