import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * A class that represents GUI objects for entering new countries.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class EnterGUI
   extends JDialog
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new GUI for entry of countries.
    *
    * @param theParentComponent the frame from which this dialog
    * was lauched (the owner of this dialog).
    * @param theCFile the file countries get inserted into.
    */
   public EnterGUI(Frame theParentComponent,
      final CountryFile theCFile)
   {  super(theParentComponent, "Enter new countries", true);
      final CountryPanel countryPanel = new CountryPanel(CountryPanel.ENTRY);
      JButton insertBtn = new JButton("INSERT");
      insertBtn.addActionListener(new ActionListener()
      {  public void actionPerformed(ActionEvent ae)
         {  try
            {  Country c = countryPanel.getCountry();
               theCFile.insert(c);
               countryPanel.clear();
            }
            catch (CountryDataInputException cdie)
            {  JOptionPane.showMessageDialog(null, 
                  "There is an error in what you have typed",
                  "Data entry problem", JOptionPane.ERROR_MESSAGE);
            }
            catch (CountryFileIOException nsce)
            {  JOptionPane.showMessageDialog(null, 
                  "There was a problem accessing the file",
                  "File problem", JOptionPane.ERROR_MESSAGE);
            }
         }
      });
      Container contentPane = getContentPane();
      contentPane.add(countryPanel, BorderLayout.NORTH);
      contentPane.add(insertBtn, BorderLayout.SOUTH);
      pack();
   }
}
