/**
 * A class that represents countries of the world.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class Country
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new country object.
    *
    * @param theName the country name.
    * @param thePop the country population.
    * @param theCurr the country currency.
    */
   public Country(String theName, int thePop, String theCurr)
   {  name = theName;
      population = thePop;
      currency = theCurr;
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/

/* --Getters----------------------------------------------------------- */

   /**
    * Returns the name of the country.
    *
    * @return the name of this country.
    */
   public String getName()
   {  return name;
   }

   /**
    * Returns the population of the country.
    *
    * @return the population of this country.
    */
   public int getPopulation()
   {  return population;
   }

   /**
    * Returns the currency of the country.
    *
    * @return the currency of this country.
    */
   public String getCurrency()
   {  return currency;
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The country's name.
    */
   private String name;

   /**
    * The country's population.
    */
   private int population;

   /**
    * The country's currency.
    */
   private String currency;
}
