import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
 * A JPanel with a moving ball.
 * @author Derek Bridge 666 d.bridge@cs.ucc.ie
 */
public class MovingBall
   extends JPanel
{
/* =======================================================================
       CONSTRUCTORS
   =======================================================================
*/
   /**
    * Allocates a new moving ball animation panel.
    */
   public MovingBall()
   {  super();
      timer = new Timer(40,
         new ActionListener()
         {  public void actionPerformed(ActionEvent ae)
            {  frameNumber++;
               repaint();
            }
         });
      addMouseListener(new MouseAdapter()
      {  public void mousePressed(MouseEvent me)
         {  if (frozen)
            {  frozen = false;
               startAnimation();
            }
            else
            {  frozen = true;
               stopAnimation();
            }
         }
      });
   }

/* =======================================================================
       PUBLIC INTERFACE
   =======================================================================
*/
   /**
    * Starts the timer that controls the animation.
    */
   public synchronized void startAnimation()
   {  if (! frozen)
      {  timer.start();
      }
   }

   /**
    * Stops the timer that controls the animation.
    */
   public synchronized void stopAnimation()
   {  timer.stop();
   }

   /**
    * Paints the panel with the ball in its latest position.
    *
    * @param g the graphics context.
    */
   public void paintComponent(Graphics g)
   {  super.paintComponent(g);
      int panelWidth = getSize().width;
      int panelHeight = getSize().height;
      Insets insets = getInsets(); // borders
      int availWidth = panelWidth - insets.left - insets.right;
      int availHeight = panelHeight - insets.top - insets.bottom;
      g.drawOval(insets.left + frameNumber % availWidth,
                 insets.top + availHeight / 2, 20, 20);
   }

/* =======================================================================
       INSTANCE VARIABLES & CLASS VARIABLES
   =======================================================================
*/
   /**
    * The timer that controls the animation.
    */
   private Timer timer;

   /**
    * Keeps track of the ball's changing position.
    */
   private int frameNumber = -1;

   /**
    * Whether the animation has been stopped by the user or not.
    */
   private boolean frozen;

/* =======================================================================
       TEST DRIVER
   =======================================================================
*/
   public static void main(String[] args)
   {  JFrame frame = new JFrame("Animation Demo");
      final MovingBall mb = new MovingBall();
      Container contentPane = frame.getContentPane();
      contentPane.add(mb);
      frame.addWindowListener(new WindowAdapter()
      {  public void windowIconified(WindowEvent we)
         {  mb.stopAnimation();
         }

         public void windowDeiconified(WindowEvent we)
         {  mb.startAnimation();
         }

         public void windowClosing(WindowEvent we)
         {  System.exit(0);
         }
      });
      frame.pack();
      frame.setVisible(true);
      mb.startAnimation();
   }
}
